/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest;

public class GetConsoleScreenshotRequestMarshaller
implements Marshaller<Request<GetConsoleScreenshotRequest>, GetConsoleScreenshotRequest> {
    public Request<GetConsoleScreenshotRequest> marshall(GetConsoleScreenshotRequest getConsoleScreenshotRequest) {
        if (getConsoleScreenshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getConsoleScreenshotRequest, "Ec2Client");
        request.addParameter("Action", "GetConsoleScreenshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getConsoleScreenshotRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)getConsoleScreenshotRequest.instanceId()));
        }
        if (getConsoleScreenshotRequest.wakeUp() != null) {
            request.addParameter("WakeUp", StringConversion.fromBoolean((Boolean)getConsoleScreenshotRequest.wakeUp()));
        }
        return request;
    }
}

