/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest;

public class DisassociateAddressRequestMarshaller
implements Marshaller<Request<DisassociateAddressRequest>, DisassociateAddressRequest> {
    public Request<DisassociateAddressRequest> marshall(DisassociateAddressRequest disassociateAddressRequest) {
        if (disassociateAddressRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)disassociateAddressRequest, "Ec2Client");
        request.addParameter("Action", "DisassociateAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (disassociateAddressRequest.associationId() != null) {
            request.addParameter("AssociationId", StringConversion.fromString((String)disassociateAddressRequest.associationId()));
        }
        if (disassociateAddressRequest.publicIp() != null) {
            request.addParameter("PublicIp", StringConversion.fromString((String)disassociateAddressRequest.publicIp()));
        }
        return request;
    }
}

