/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpnGatewaysRequestMarshaller
implements Marshaller<Request<DescribeVpnGatewaysRequest>, DescribeVpnGatewaysRequest> {
    public Request<DescribeVpnGatewaysRequest> marshall(DescribeVpnGatewaysRequest describeVpnGatewaysRequest) {
        List<String> describeVpnGatewaysRequestVpnGatewayIdsList;
        if (describeVpnGatewaysRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpnGatewaysRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVpnGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVpnGatewaysRequestFiltersList = describeVpnGatewaysRequest.filters();
        if (!describeVpnGatewaysRequestFiltersList.isEmpty() || !(describeVpnGatewaysRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVpnGatewaysRequestFiltersListValue : describeVpnGatewaysRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpnGatewaysRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVpnGatewaysRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVpnGatewaysRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVpnGatewaysRequestVpnGatewayIdsList = describeVpnGatewaysRequest.vpnGatewayIds()).isEmpty() || !(describeVpnGatewaysRequestVpnGatewayIdsList instanceof SdkAutoConstructList)) {
            int vpnGatewayIdsListIndex = 1;
            for (String describeVpnGatewaysRequestVpnGatewayIdsListValue : describeVpnGatewaysRequestVpnGatewayIdsList) {
                if (describeVpnGatewaysRequestVpnGatewayIdsListValue != null) {
                    request.addParameter("VpnGatewayId." + vpnGatewayIdsListIndex, StringConversion.fromString((String)describeVpnGatewaysRequestVpnGatewayIdsListValue));
                }
                ++vpnGatewayIdsListIndex;
            }
        }
        return request;
    }
}

