/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcEndpointServicesRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointServicesRequest>, DescribeVpcEndpointServicesRequest> {
    public Request<DescribeVpcEndpointServicesRequest> marshall(DescribeVpcEndpointServicesRequest describeVpcEndpointServicesRequest) {
        List<Filter> describeVpcEndpointServicesRequestFiltersList;
        if (describeVpcEndpointServicesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpcEndpointServicesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVpcEndpointServices");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeVpcEndpointServicesRequestServiceNamesList = describeVpcEndpointServicesRequest.serviceNames();
        if (!describeVpcEndpointServicesRequestServiceNamesList.isEmpty() || !(describeVpcEndpointServicesRequestServiceNamesList instanceof SdkAutoConstructList)) {
            int serviceNamesListIndex = 1;
            for (String describeVpcEndpointServicesRequestServiceNamesListValue : describeVpcEndpointServicesRequestServiceNamesList) {
                if (describeVpcEndpointServicesRequestServiceNamesListValue != null) {
                    request.addParameter("ServiceName." + serviceNamesListIndex, StringConversion.fromString((String)describeVpcEndpointServicesRequestServiceNamesListValue));
                }
                ++serviceNamesListIndex;
            }
        }
        if (!(describeVpcEndpointServicesRequestFiltersList = describeVpcEndpointServicesRequest.filters()).isEmpty() || !(describeVpcEndpointServicesRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointServicesRequestFiltersListValue : describeVpcEndpointServicesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcEndpointServicesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVpcEndpointServicesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVpcEndpointServicesRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointServicesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeVpcEndpointServicesRequest.maxResults()));
        }
        if (describeVpcEndpointServicesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeVpcEndpointServicesRequest.nextToken()));
        }
        return request;
    }
}

