/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVolumeStatusRequestMarshaller
implements Marshaller<Request<DescribeVolumeStatusRequest>, DescribeVolumeStatusRequest> {
    public Request<DescribeVolumeStatusRequest> marshall(DescribeVolumeStatusRequest describeVolumeStatusRequest) {
        List<String> describeVolumeStatusRequestVolumeIdsList;
        if (describeVolumeStatusRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVolumeStatusRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVolumeStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVolumeStatusRequestFiltersList = describeVolumeStatusRequest.filters();
        if (!describeVolumeStatusRequestFiltersList.isEmpty() || !(describeVolumeStatusRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVolumeStatusRequestFiltersListValue : describeVolumeStatusRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVolumeStatusRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVolumeStatusRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVolumeStatusRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVolumeStatusRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeVolumeStatusRequest.maxResults()));
        }
        if (describeVolumeStatusRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeVolumeStatusRequest.nextToken()));
        }
        if (!(describeVolumeStatusRequestVolumeIdsList = describeVolumeStatusRequest.volumeIds()).isEmpty() || !(describeVolumeStatusRequestVolumeIdsList instanceof SdkAutoConstructList)) {
            int volumeIdsListIndex = 1;
            for (String describeVolumeStatusRequestVolumeIdsListValue : describeVolumeStatusRequestVolumeIdsList) {
                if (describeVolumeStatusRequestVolumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex, StringConversion.fromString((String)describeVolumeStatusRequestVolumeIdsListValue));
                }
                ++volumeIdsListIndex;
            }
        }
        return request;
    }
}

