/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;

public class DescribeSpotFleetRequestsRequestMarshaller
implements Marshaller<Request<DescribeSpotFleetRequestsRequest>, DescribeSpotFleetRequestsRequest> {
    public Request<DescribeSpotFleetRequestsRequest> marshall(DescribeSpotFleetRequestsRequest describeSpotFleetRequestsRequest) {
        List<String> describeSpotFleetRequestsRequestSpotFleetRequestIdsList;
        if (describeSpotFleetRequestsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSpotFleetRequestsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeSpotFleetRequests");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSpotFleetRequestsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeSpotFleetRequestsRequest.maxResults()));
        }
        if (describeSpotFleetRequestsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeSpotFleetRequestsRequest.nextToken()));
        }
        if (!(describeSpotFleetRequestsRequestSpotFleetRequestIdsList = describeSpotFleetRequestsRequest.spotFleetRequestIds()).isEmpty() || !(describeSpotFleetRequestsRequestSpotFleetRequestIdsList instanceof SdkAutoConstructList)) {
            int spotFleetRequestIdsListIndex = 1;
            for (String describeSpotFleetRequestsRequestSpotFleetRequestIdsListValue : describeSpotFleetRequestsRequestSpotFleetRequestIdsList) {
                if (describeSpotFleetRequestsRequestSpotFleetRequestIdsListValue != null) {
                    request.addParameter("SpotFleetRequestId." + spotFleetRequestIdsListIndex, StringConversion.fromString((String)describeSpotFleetRequestsRequestSpotFleetRequestIdsListValue));
                }
                ++spotFleetRequestIdsListIndex;
            }
        }
        return request;
    }
}

