/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeRegionsRequestMarshaller
implements Marshaller<Request<DescribeRegionsRequest>, DescribeRegionsRequest> {
    public Request<DescribeRegionsRequest> marshall(DescribeRegionsRequest describeRegionsRequest) {
        List<String> describeRegionsRequestRegionNamesList;
        if (describeRegionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeRegionsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeRegions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeRegionsRequestFiltersList = describeRegionsRequest.filters();
        if (!describeRegionsRequestFiltersList.isEmpty() || !(describeRegionsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeRegionsRequestFiltersListValue : describeRegionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeRegionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeRegionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeRegionsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeRegionsRequestRegionNamesList = describeRegionsRequest.regionNames()).isEmpty() || !(describeRegionsRequestRegionNamesList instanceof SdkAutoConstructList)) {
            int regionNamesListIndex = 1;
            for (String describeRegionsRequestRegionNamesListValue : describeRegionsRequestRegionNamesList) {
                if (describeRegionsRequestRegionNamesListValue != null) {
                    request.addParameter("RegionName." + regionNamesListIndex, StringConversion.fromString((String)describeRegionsRequestRegionNamesListValue));
                }
                ++regionNamesListIndex;
            }
        }
        return request;
    }
}

