/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeNetworkAclsRequestMarshaller
implements Marshaller<Request<DescribeNetworkAclsRequest>, DescribeNetworkAclsRequest> {
    public Request<DescribeNetworkAclsRequest> marshall(DescribeNetworkAclsRequest describeNetworkAclsRequest) {
        List<String> describeNetworkAclsRequestNetworkAclIdsList;
        if (describeNetworkAclsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeNetworkAclsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeNetworkAcls");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeNetworkAclsRequestFiltersList = describeNetworkAclsRequest.filters();
        if (!describeNetworkAclsRequestFiltersList.isEmpty() || !(describeNetworkAclsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeNetworkAclsRequestFiltersListValue : describeNetworkAclsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeNetworkAclsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeNetworkAclsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeNetworkAclsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeNetworkAclsRequestNetworkAclIdsList = describeNetworkAclsRequest.networkAclIds()).isEmpty() || !(describeNetworkAclsRequestNetworkAclIdsList instanceof SdkAutoConstructList)) {
            int networkAclIdsListIndex = 1;
            for (String describeNetworkAclsRequestNetworkAclIdsListValue : describeNetworkAclsRequestNetworkAclIdsList) {
                if (describeNetworkAclsRequestNetworkAclIdsListValue != null) {
                    request.addParameter("NetworkAclId." + networkAclIdsListIndex, StringConversion.fromString((String)describeNetworkAclsRequestNetworkAclIdsListValue));
                }
                ++networkAclIdsListIndex;
            }
        }
        return request;
    }
}

