/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeImportImageTasksRequestMarshaller
implements Marshaller<Request<DescribeImportImageTasksRequest>, DescribeImportImageTasksRequest> {
    public Request<DescribeImportImageTasksRequest> marshall(DescribeImportImageTasksRequest describeImportImageTasksRequest) {
        List<String> describeImportImageTasksRequestImportTaskIdsList;
        if (describeImportImageTasksRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeImportImageTasksRequest, "Ec2Client");
        request.addParameter("Action", "DescribeImportImageTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeImportImageTasksRequestFiltersList = describeImportImageTasksRequest.filters();
        if (!describeImportImageTasksRequestFiltersList.isEmpty() || !(describeImportImageTasksRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeImportImageTasksRequestFiltersListValue : describeImportImageTasksRequestFiltersList) {
                List<String> filterValuesList;
                if (describeImportImageTasksRequestFiltersListValue.name() != null) {
                    request.addParameter("Filters." + filtersListIndex + ".Name", StringConversion.fromString((String)describeImportImageTasksRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeImportImageTasksRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filters." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeImportImageTasksRequestImportTaskIdsList = describeImportImageTasksRequest.importTaskIds()).isEmpty() || !(describeImportImageTasksRequestImportTaskIdsList instanceof SdkAutoConstructList)) {
            int importTaskIdsListIndex = 1;
            for (String describeImportImageTasksRequestImportTaskIdsListValue : describeImportImageTasksRequestImportTaskIdsList) {
                if (describeImportImageTasksRequestImportTaskIdsListValue != null) {
                    request.addParameter("ImportTaskId." + importTaskIdsListIndex, StringConversion.fromString((String)describeImportImageTasksRequestImportTaskIdsListValue));
                }
                ++importTaskIdsListIndex;
            }
        }
        if (describeImportImageTasksRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeImportImageTasksRequest.maxResults()));
        }
        if (describeImportImageTasksRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeImportImageTasksRequest.nextToken()));
        }
        return request;
    }
}

