/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeHostReservationOfferingsRequestMarshaller
implements Marshaller<Request<DescribeHostReservationOfferingsRequest>, DescribeHostReservationOfferingsRequest> {
    public Request<DescribeHostReservationOfferingsRequest> marshall(DescribeHostReservationOfferingsRequest describeHostReservationOfferingsRequest) {
        if (describeHostReservationOfferingsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeHostReservationOfferingsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeHostReservationOfferings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeHostReservationOfferingsRequestFilterList = describeHostReservationOfferingsRequest.filter();
        if (!describeHostReservationOfferingsRequestFilterList.isEmpty() || !(describeHostReservationOfferingsRequestFilterList instanceof SdkAutoConstructList)) {
            int filterListIndex = 1;
            for (Filter describeHostReservationOfferingsRequestFilterListValue : describeHostReservationOfferingsRequestFilterList) {
                List<String> filterValuesList;
                if (describeHostReservationOfferingsRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringConversion.fromString((String)describeHostReservationOfferingsRequestFilterListValue.name()));
                }
                if (!(filterValuesList = describeHostReservationOfferingsRequestFilterListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeHostReservationOfferingsRequest.maxDuration() != null) {
            request.addParameter("MaxDuration", StringConversion.fromInteger((Integer)describeHostReservationOfferingsRequest.maxDuration()));
        }
        if (describeHostReservationOfferingsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeHostReservationOfferingsRequest.maxResults()));
        }
        if (describeHostReservationOfferingsRequest.minDuration() != null) {
            request.addParameter("MinDuration", StringConversion.fromInteger((Integer)describeHostReservationOfferingsRequest.minDuration()));
        }
        if (describeHostReservationOfferingsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeHostReservationOfferingsRequest.nextToken()));
        }
        if (describeHostReservationOfferingsRequest.offeringId() != null) {
            request.addParameter("OfferingId", StringConversion.fromString((String)describeHostReservationOfferingsRequest.offeringId()));
        }
        return request;
    }
}

