/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeFpgaImagesRequestMarshaller
implements Marshaller<Request<DescribeFpgaImagesRequest>, DescribeFpgaImagesRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeFpgaImagesRequest> marshall(DescribeFpgaImagesRequest describeFpgaImagesRequest) {
        List<Filter> describeFpgaImagesRequestFiltersList;
        List<String> describeFpgaImagesRequestOwnersList;
        if (describeFpgaImagesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeFpgaImagesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeFpgaImages");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeFpgaImagesRequestFpgaImageIdsList = describeFpgaImagesRequest.fpgaImageIds();
        if (!describeFpgaImagesRequestFpgaImageIdsList.isEmpty() || !(describeFpgaImagesRequestFpgaImageIdsList instanceof SdkAutoConstructList)) {
            int fpgaImageIdsListIndex = 1;
            for (String string : describeFpgaImagesRequestFpgaImageIdsList) {
                if (string != null) {
                    request.addParameter("FpgaImageId." + fpgaImageIdsListIndex, StringConversion.fromString((String)string));
                }
                ++fpgaImageIdsListIndex;
            }
        }
        if (!(describeFpgaImagesRequestOwnersList = describeFpgaImagesRequest.owners()).isEmpty() || !(describeFpgaImagesRequestOwnersList instanceof SdkAutoConstructList)) {
            int ownersListIndex = 1;
            for (String describeFpgaImagesRequestOwnersListValue : describeFpgaImagesRequestOwnersList) {
                if (describeFpgaImagesRequestOwnersListValue != null) {
                    request.addParameter("Owner." + ownersListIndex, StringConversion.fromString((String)describeFpgaImagesRequestOwnersListValue));
                }
                ++ownersListIndex;
            }
        }
        if (!(describeFpgaImagesRequestFiltersList = describeFpgaImagesRequest.filters()).isEmpty() || !(describeFpgaImagesRequestFiltersList instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (Filter describeFpgaImagesRequestFiltersListValue : describeFpgaImagesRequestFiltersList) {
                List<String> filterValuesList;
                void var6_12;
                if (describeFpgaImagesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + (int)var6_12 + ".Name", StringConversion.fromString((String)describeFpgaImagesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeFpgaImagesRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + (int)var6_12 + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++var6_12;
            }
        }
        if (describeFpgaImagesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeFpgaImagesRequest.nextToken()));
        }
        if (describeFpgaImagesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeFpgaImagesRequest.maxResults()));
        }
        return request;
    }
}

