/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest;

public class DescribeEgressOnlyInternetGatewaysRequestMarshaller
implements Marshaller<Request<DescribeEgressOnlyInternetGatewaysRequest>, DescribeEgressOnlyInternetGatewaysRequest> {
    public Request<DescribeEgressOnlyInternetGatewaysRequest> marshall(DescribeEgressOnlyInternetGatewaysRequest describeEgressOnlyInternetGatewaysRequest) {
        if (describeEgressOnlyInternetGatewaysRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeEgressOnlyInternetGatewaysRequest, "Ec2Client");
        request.addParameter("Action", "DescribeEgressOnlyInternetGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeEgressOnlyInternetGatewaysRequestEgressOnlyInternetGatewayIdsList = describeEgressOnlyInternetGatewaysRequest.egressOnlyInternetGatewayIds();
        if (!describeEgressOnlyInternetGatewaysRequestEgressOnlyInternetGatewayIdsList.isEmpty() || !(describeEgressOnlyInternetGatewaysRequestEgressOnlyInternetGatewayIdsList instanceof SdkAutoConstructList)) {
            int egressOnlyInternetGatewayIdsListIndex = 1;
            for (String describeEgressOnlyInternetGatewaysRequestEgressOnlyInternetGatewayIdsListValue : describeEgressOnlyInternetGatewaysRequestEgressOnlyInternetGatewayIdsList) {
                if (describeEgressOnlyInternetGatewaysRequestEgressOnlyInternetGatewayIdsListValue != null) {
                    request.addParameter("EgressOnlyInternetGatewayId." + egressOnlyInternetGatewayIdsListIndex, StringConversion.fromString((String)describeEgressOnlyInternetGatewaysRequestEgressOnlyInternetGatewayIdsListValue));
                }
                ++egressOnlyInternetGatewayIdsListIndex;
            }
        }
        if (describeEgressOnlyInternetGatewaysRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeEgressOnlyInternetGatewaysRequest.maxResults()));
        }
        if (describeEgressOnlyInternetGatewaysRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeEgressOnlyInternetGatewaysRequest.nextToken()));
        }
        return request;
    }
}

