/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeBundleTasksRequestMarshaller
implements Marshaller<Request<DescribeBundleTasksRequest>, DescribeBundleTasksRequest> {
    public Request<DescribeBundleTasksRequest> marshall(DescribeBundleTasksRequest describeBundleTasksRequest) {
        List<Filter> describeBundleTasksRequestFiltersList;
        if (describeBundleTasksRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeBundleTasksRequest, "Ec2Client");
        request.addParameter("Action", "DescribeBundleTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeBundleTasksRequestBundleIdsList = describeBundleTasksRequest.bundleIds();
        if (!describeBundleTasksRequestBundleIdsList.isEmpty() || !(describeBundleTasksRequestBundleIdsList instanceof SdkAutoConstructList)) {
            int bundleIdsListIndex = 1;
            for (String describeBundleTasksRequestBundleIdsListValue : describeBundleTasksRequestBundleIdsList) {
                if (describeBundleTasksRequestBundleIdsListValue != null) {
                    request.addParameter("BundleId." + bundleIdsListIndex, StringConversion.fromString((String)describeBundleTasksRequestBundleIdsListValue));
                }
                ++bundleIdsListIndex;
            }
        }
        if (!(describeBundleTasksRequestFiltersList = describeBundleTasksRequest.filters()).isEmpty() || !(describeBundleTasksRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeBundleTasksRequestFiltersListValue : describeBundleTasksRequestFiltersList) {
                List<String> filterValuesList;
                if (describeBundleTasksRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeBundleTasksRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeBundleTasksRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

