/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest;

public class DeleteSecurityGroupRequestMarshaller
implements Marshaller<Request<DeleteSecurityGroupRequest>, DeleteSecurityGroupRequest> {
    public Request<DeleteSecurityGroupRequest> marshall(DeleteSecurityGroupRequest deleteSecurityGroupRequest) {
        if (deleteSecurityGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteSecurityGroupRequest, "Ec2Client");
        request.addParameter("Action", "DeleteSecurityGroup");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteSecurityGroupRequest.groupId() != null) {
            request.addParameter("GroupId", StringConversion.fromString((String)deleteSecurityGroupRequest.groupId()));
        }
        if (deleteSecurityGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)deleteSecurityGroupRequest.groupName()));
        }
        return request;
    }
}

