/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest;

public class DeleteRouteTableRequestMarshaller
implements Marshaller<Request<DeleteRouteTableRequest>, DeleteRouteTableRequest> {
    public Request<DeleteRouteTableRequest> marshall(DeleteRouteTableRequest deleteRouteTableRequest) {
        if (deleteRouteTableRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteRouteTableRequest, "Ec2Client");
        request.addParameter("Action", "DeleteRouteTable");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteRouteTableRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringConversion.fromString((String)deleteRouteTableRequest.routeTableId()));
        }
        return request;
    }
}

