/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest;

public class DeleteKeyPairRequestMarshaller
implements Marshaller<Request<DeleteKeyPairRequest>, DeleteKeyPairRequest> {
    public Request<DeleteKeyPairRequest> marshall(DeleteKeyPairRequest deleteKeyPairRequest) {
        if (deleteKeyPairRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteKeyPairRequest, "Ec2Client");
        request.addParameter("Action", "DeleteKeyPair");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteKeyPairRequest.keyName() != null) {
            request.addParameter("KeyName", StringConversion.fromString((String)deleteKeyPairRequest.keyName()));
        }
        return request;
    }
}

