/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteRequest;

public class CreateVpnConnectionRouteRequestMarshaller
implements Marshaller<Request<CreateVpnConnectionRouteRequest>, CreateVpnConnectionRouteRequest> {
    public Request<CreateVpnConnectionRouteRequest> marshall(CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest) {
        if (createVpnConnectionRouteRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createVpnConnectionRouteRequest, "Ec2Client");
        request.addParameter("Action", "CreateVpnConnectionRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpnConnectionRouteRequest.destinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringConversion.fromString((String)createVpnConnectionRouteRequest.destinationCidrBlock()));
        }
        if (createVpnConnectionRouteRequest.vpnConnectionId() != null) {
            request.addParameter("VpnConnectionId", StringConversion.fromString((String)createVpnConnectionRouteRequest.vpnConnectionId()));
        }
        return request;
    }
}

