/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest;

public class CreateVpcPeeringConnectionRequestMarshaller
implements Marshaller<Request<CreateVpcPeeringConnectionRequest>, CreateVpcPeeringConnectionRequest> {
    public Request<CreateVpcPeeringConnectionRequest> marshall(CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) {
        if (createVpcPeeringConnectionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createVpcPeeringConnectionRequest, "Ec2Client");
        request.addParameter("Action", "CreateVpcPeeringConnection");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcPeeringConnectionRequest.peerOwnerId() != null) {
            request.addParameter("PeerOwnerId", StringConversion.fromString((String)createVpcPeeringConnectionRequest.peerOwnerId()));
        }
        if (createVpcPeeringConnectionRequest.peerVpcId() != null) {
            request.addParameter("PeerVpcId", StringConversion.fromString((String)createVpcPeeringConnectionRequest.peerVpcId()));
        }
        if (createVpcPeeringConnectionRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)createVpcPeeringConnectionRequest.vpcId()));
        }
        return request;
    }
}

