/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateSubnetRequest;

public class CreateSubnetRequestMarshaller
implements Marshaller<Request<CreateSubnetRequest>, CreateSubnetRequest> {
    public Request<CreateSubnetRequest> marshall(CreateSubnetRequest createSubnetRequest) {
        if (createSubnetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createSubnetRequest, "Ec2Client");
        request.addParameter("Action", "CreateSubnet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSubnetRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)createSubnetRequest.availabilityZone()));
        }
        if (createSubnetRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringConversion.fromString((String)createSubnetRequest.cidrBlock()));
        }
        if (createSubnetRequest.ipv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringConversion.fromString((String)createSubnetRequest.ipv6CidrBlock()));
        }
        if (createSubnetRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)createSubnetRequest.vpcId()));
        }
        return request;
    }
}

