/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotRequest;

public class CreateSnapshotRequestMarshaller
implements Marshaller<Request<CreateSnapshotRequest>, CreateSnapshotRequest> {
    public Request<CreateSnapshotRequest> marshall(CreateSnapshotRequest createSnapshotRequest) {
        if (createSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createSnapshotRequest, "Ec2Client");
        request.addParameter("Action", "CreateSnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSnapshotRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createSnapshotRequest.description()));
        }
        if (createSnapshotRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringConversion.fromString((String)createSnapshotRequest.volumeId()));
        }
        return request;
    }
}

