/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest;

public class CreatePlacementGroupRequestMarshaller
implements Marshaller<Request<CreatePlacementGroupRequest>, CreatePlacementGroupRequest> {
    public Request<CreatePlacementGroupRequest> marshall(CreatePlacementGroupRequest createPlacementGroupRequest) {
        if (createPlacementGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createPlacementGroupRequest, "Ec2Client");
        request.addParameter("Action", "CreatePlacementGroup");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlacementGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)createPlacementGroupRequest.groupName()));
        }
        if (createPlacementGroupRequest.strategyAsString() != null) {
            request.addParameter("Strategy", StringConversion.fromString((String)createPlacementGroupRequest.strategyAsString()));
        }
        return request;
    }
}

