/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.IcmpTypeCode;
import software.amazon.awssdk.services.ec2.model.PortRange;

public class CreateNetworkAclEntryRequestMarshaller
implements Marshaller<Request<CreateNetworkAclEntryRequest>, CreateNetworkAclEntryRequest> {
    public Request<CreateNetworkAclEntryRequest> marshall(CreateNetworkAclEntryRequest createNetworkAclEntryRequest) {
        PortRange portRange;
        IcmpTypeCode icmpTypeCode;
        if (createNetworkAclEntryRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createNetworkAclEntryRequest, "Ec2Client");
        request.addParameter("Action", "CreateNetworkAclEntry");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkAclEntryRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringConversion.fromString((String)createNetworkAclEntryRequest.cidrBlock()));
        }
        if (createNetworkAclEntryRequest.egress() != null) {
            request.addParameter("Egress", StringConversion.fromBoolean((Boolean)createNetworkAclEntryRequest.egress()));
        }
        if ((icmpTypeCode = createNetworkAclEntryRequest.icmpTypeCode()) != null) {
            if (icmpTypeCode.code() != null) {
                request.addParameter("Icmp.Code", StringConversion.fromInteger((Integer)icmpTypeCode.code()));
            }
            if (icmpTypeCode.type() != null) {
                request.addParameter("Icmp.Type", StringConversion.fromInteger((Integer)icmpTypeCode.type()));
            }
        }
        if (createNetworkAclEntryRequest.ipv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringConversion.fromString((String)createNetworkAclEntryRequest.ipv6CidrBlock()));
        }
        if (createNetworkAclEntryRequest.networkAclId() != null) {
            request.addParameter("NetworkAclId", StringConversion.fromString((String)createNetworkAclEntryRequest.networkAclId()));
        }
        if ((portRange = createNetworkAclEntryRequest.portRange()) != null) {
            if (portRange.from() != null) {
                request.addParameter("PortRange.From", StringConversion.fromInteger((Integer)portRange.from()));
            }
            if (portRange.to() != null) {
                request.addParameter("PortRange.To", StringConversion.fromInteger((Integer)portRange.to()));
            }
        }
        if (createNetworkAclEntryRequest.protocol() != null) {
            request.addParameter("Protocol", StringConversion.fromString((String)createNetworkAclEntryRequest.protocol()));
        }
        if (createNetworkAclEntryRequest.ruleActionAsString() != null) {
            request.addParameter("RuleAction", StringConversion.fromString((String)createNetworkAclEntryRequest.ruleActionAsString()));
        }
        if (createNetworkAclEntryRequest.ruleNumber() != null) {
            request.addParameter("RuleNumber", StringConversion.fromInteger((Integer)createNetworkAclEntryRequest.ruleNumber()));
        }
        return request;
    }
}

