/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.ExportToS3TaskSpecification;

public class CreateInstanceExportTaskRequestMarshaller
implements Marshaller<Request<CreateInstanceExportTaskRequest>, CreateInstanceExportTaskRequest> {
    public Request<CreateInstanceExportTaskRequest> marshall(CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {
        ExportToS3TaskSpecification exportToS3Task;
        if (createInstanceExportTaskRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createInstanceExportTaskRequest, "Ec2Client");
        request.addParameter("Action", "CreateInstanceExportTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createInstanceExportTaskRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createInstanceExportTaskRequest.description()));
        }
        if ((exportToS3Task = createInstanceExportTaskRequest.exportToS3Task()) != null) {
            if (exportToS3Task.containerFormatAsString() != null) {
                request.addParameter("ExportToS3.ContainerFormat", StringConversion.fromString((String)exportToS3Task.containerFormatAsString()));
            }
            if (exportToS3Task.diskImageFormatAsString() != null) {
                request.addParameter("ExportToS3.DiskImageFormat", StringConversion.fromString((String)exportToS3Task.diskImageFormatAsString()));
            }
            if (exportToS3Task.s3Bucket() != null) {
                request.addParameter("ExportToS3.S3Bucket", StringConversion.fromString((String)exportToS3Task.s3Bucket()));
            }
            if (exportToS3Task.s3Prefix() != null) {
                request.addParameter("ExportToS3.S3Prefix", StringConversion.fromString((String)exportToS3Task.s3Prefix()));
            }
        }
        if (createInstanceExportTaskRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)createInstanceExportTaskRequest.instanceId()));
        }
        if (createInstanceExportTaskRequest.targetEnvironmentAsString() != null) {
            request.addParameter("TargetEnvironment", StringConversion.fromString((String)createInstanceExportTaskRequest.targetEnvironmentAsString()));
        }
        return request;
    }
}

