/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest;

public class CancelConversionTaskRequestMarshaller
implements Marshaller<Request<CancelConversionTaskRequest>, CancelConversionTaskRequest> {
    public Request<CancelConversionTaskRequest> marshall(CancelConversionTaskRequest cancelConversionTaskRequest) {
        if (cancelConversionTaskRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)cancelConversionTaskRequest, "Ec2Client");
        request.addParameter("Action", "CancelConversionTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (cancelConversionTaskRequest.conversionTaskId() != null) {
            request.addParameter("ConversionTaskId", StringConversion.fromString((String)cancelConversionTaskRequest.conversionTaskId()));
        }
        if (cancelConversionTaskRequest.reasonMessage() != null) {
            request.addParameter("ReasonMessage", StringConversion.fromString((String)cancelConversionTaskRequest.reasonMessage()));
        }
        return request;
    }
}

