/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AttachVolumeRequest;

public class AttachVolumeRequestMarshaller
implements Marshaller<Request<AttachVolumeRequest>, AttachVolumeRequest> {
    public Request<AttachVolumeRequest> marshall(AttachVolumeRequest attachVolumeRequest) {
        if (attachVolumeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)attachVolumeRequest, "Ec2Client");
        request.addParameter("Action", "AttachVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachVolumeRequest.device() != null) {
            request.addParameter("Device", StringConversion.fromString((String)attachVolumeRequest.device()));
        }
        if (attachVolumeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)attachVolumeRequest.instanceId()));
        }
        if (attachVolumeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringConversion.fromString((String)attachVolumeRequest.volumeId()));
        }
        return request;
    }
}

