/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AssociateAddressRequest;

public class AssociateAddressRequestMarshaller
implements Marshaller<Request<AssociateAddressRequest>, AssociateAddressRequest> {
    public Request<AssociateAddressRequest> marshall(AssociateAddressRequest associateAddressRequest) {
        if (associateAddressRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)associateAddressRequest, "Ec2Client");
        request.addParameter("Action", "AssociateAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (associateAddressRequest.allocationId() != null) {
            request.addParameter("AllocationId", StringConversion.fromString((String)associateAddressRequest.allocationId()));
        }
        if (associateAddressRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)associateAddressRequest.instanceId()));
        }
        if (associateAddressRequest.publicIp() != null) {
            request.addParameter("PublicIp", StringConversion.fromString((String)associateAddressRequest.publicIp()));
        }
        if (associateAddressRequest.allowReassociation() != null) {
            request.addParameter("AllowReassociation", StringConversion.fromBoolean((Boolean)associateAddressRequest.allowReassociation()));
        }
        if (associateAddressRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringConversion.fromString((String)associateAddressRequest.networkInterfaceId()));
        }
        if (associateAddressRequest.privateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringConversion.fromString((String)associateAddressRequest.privateIpAddress()));
        }
        return request;
    }
}

