/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.Volume;

public class DescribeVolumesPublisher
implements SdkPublisher<DescribeVolumesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVolumesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVolumesPublisher(Ec2AsyncClient client, DescribeVolumesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVolumesPublisher(Ec2AsyncClient client, DescribeVolumesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVolumesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVolumesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Volume> volumes() {
        Function<DescribeVolumesResponse, Iterator> getIterator = response -> {
            if (response != null && response.volumes() != null) {
                return response.volumes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVolumesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeVolumesPublisher resume(DescribeVolumesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeVolumesPublisher(this.client, (DescribeVolumesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeVolumesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeVolumesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeVolumesResponseFetcher
    implements AsyncPageFetcher<DescribeVolumesResponse> {
        private DescribeVolumesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeVolumesResponse> nextPage(DescribeVolumesResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumesPublisher.this.client.describeVolumes(DescribeVolumesPublisher.this.firstRequest);
            }
            return DescribeVolumesPublisher.this.client.describeVolumes((DescribeVolumesRequest)((Object)DescribeVolumesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

