/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.NatGateway;

public class DescribeNatGatewaysPublisher
implements SdkPublisher<DescribeNatGatewaysResponse> {
    private final Ec2AsyncClient client;
    private final DescribeNatGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNatGatewaysPublisher(Ec2AsyncClient client, DescribeNatGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNatGatewaysPublisher(Ec2AsyncClient client, DescribeNatGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNatGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNatGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NatGateway> natGateways() {
        Function<DescribeNatGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.natGateways() != null) {
                return response.natGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeNatGatewaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeNatGatewaysPublisher resume(DescribeNatGatewaysResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeNatGatewaysPublisher(this.client, (DescribeNatGatewaysRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeNatGatewaysPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeNatGatewaysResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeNatGatewaysResponseFetcher
    implements AsyncPageFetcher<DescribeNatGatewaysResponse> {
        private DescribeNatGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNatGatewaysResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeNatGatewaysResponse> nextPage(DescribeNatGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeNatGatewaysPublisher.this.client.describeNatGateways(DescribeNatGatewaysPublisher.this.firstRequest);
            }
            return DescribeNatGatewaysPublisher.this.client.describeNatGateways((DescribeNatGatewaysRequest)((Object)DescribeNatGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

