/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVolumeAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVolumeAttributeRequest> {
    private final Boolean autoEnableIO;
    private final String volumeId;

    private ModifyVolumeAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.autoEnableIO = builder.autoEnableIO;
        this.volumeId = builder.volumeId;
    }

    public Boolean autoEnableIO() {
        return this.autoEnableIO;
    }

    public String volumeId() {
        return this.volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableIO());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeAttributeRequest)) {
            return false;
        }
        ModifyVolumeAttributeRequest other = (ModifyVolumeAttributeRequest)((Object)obj);
        return Objects.equals(this.autoEnableIO(), other.autoEnableIO()) && Objects.equals(this.volumeId(), other.volumeId());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVolumeAttributeRequest").add("AutoEnableIO", (Object)this.autoEnableIO()).add("VolumeId", (Object)this.volumeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoEnableIO": {
                return Optional.ofNullable(clazz.cast(this.autoEnableIO()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean autoEnableIO;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeAttributeRequest model) {
            super(model);
            this.autoEnableIO(model.autoEnableIO);
            this.volumeId(model.volumeId);
        }

        public final Boolean getAutoEnableIO() {
            return this.autoEnableIO;
        }

        @Override
        public final Builder autoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
            return this;
        }

        public final void setAutoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVolumeAttributeRequest build() {
            return new ModifyVolumeAttributeRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, ModifyVolumeAttributeRequest> {
        public Builder autoEnableIO(Boolean var1);

        public Builder volumeId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

