/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.StatusName;
import software.amazon.awssdk.services.ec2.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceStatusDetails
implements ToCopyableBuilder<Builder, InstanceStatusDetails> {
    private final Instant impairedSince;
    private final String name;
    private final String status;

    private InstanceStatusDetails(BuilderImpl builder) {
        this.impairedSince = builder.impairedSince;
        this.name = builder.name;
        this.status = builder.status;
    }

    public Instant impairedSince() {
        return this.impairedSince;
    }

    public StatusName name() {
        return StatusName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.impairedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusDetails)) {
            return false;
        }
        InstanceStatusDetails other = (InstanceStatusDetails)obj;
        return Objects.equals(this.impairedSince(), other.impairedSince()) && Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"InstanceStatusDetails").add("ImpairedSince", (Object)this.impairedSince()).add("Name", (Object)this.nameAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImpairedSince": {
                return Optional.ofNullable(clazz.cast(this.impairedSince()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant impairedSince;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusDetails model) {
            this.impairedSince(model.impairedSince);
            this.name(model.name);
            this.status(model.status);
        }

        public final Instant getImpairedSince() {
            return this.impairedSince;
        }

        @Override
        public final Builder impairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
            return this;
        }

        public final void setImpairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(StatusName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public InstanceStatusDetails build() {
            return new InstanceStatusDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceStatusDetails> {
        public Builder impairedSince(Instant var1);

        public Builder name(String var1);

        public Builder name(StatusName var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);
    }
}

