/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.StaleSecurityGroup;
import software.amazon.awssdk.services.ec2.model.StaleSecurityGroupSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStaleSecurityGroupsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeStaleSecurityGroupsResponse> {
    private final String nextToken;
    private final List<StaleSecurityGroup> staleSecurityGroupSet;

    private DescribeStaleSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.staleSecurityGroupSet = builder.staleSecurityGroupSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<StaleSecurityGroup> staleSecurityGroupSet() {
        return this.staleSecurityGroupSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.staleSecurityGroupSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStaleSecurityGroupsResponse)) {
            return false;
        }
        DescribeStaleSecurityGroupsResponse other = (DescribeStaleSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.staleSecurityGroupSet(), other.staleSecurityGroupSet());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStaleSecurityGroupsResponse").add("NextToken", (Object)this.nextToken()).add("StaleSecurityGroupSet", this.staleSecurityGroupSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StaleSecurityGroupSet": {
                return Optional.ofNullable(clazz.cast(this.staleSecurityGroupSet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StaleSecurityGroup> staleSecurityGroupSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStaleSecurityGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.staleSecurityGroupSet(model.staleSecurityGroupSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<StaleSecurityGroup.Builder> getStaleSecurityGroupSet() {
            return this.staleSecurityGroupSet != null ? (Collection)this.staleSecurityGroupSet.stream().map(StaleSecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staleSecurityGroupSet(Collection<StaleSecurityGroup> staleSecurityGroupSet) {
            this.staleSecurityGroupSet = StaleSecurityGroupSetCopier.copy(staleSecurityGroupSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleSecurityGroupSet(StaleSecurityGroup ... staleSecurityGroupSet) {
            this.staleSecurityGroupSet(Arrays.asList(staleSecurityGroupSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleSecurityGroupSet(Consumer<StaleSecurityGroup.Builder> ... staleSecurityGroupSet) {
            this.staleSecurityGroupSet(Stream.of(staleSecurityGroupSet).map(c -> (StaleSecurityGroup)((StaleSecurityGroup.Builder)StaleSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStaleSecurityGroupSet(Collection<StaleSecurityGroup.BuilderImpl> staleSecurityGroupSet) {
            this.staleSecurityGroupSet = StaleSecurityGroupSetCopier.copyFromBuilder(staleSecurityGroupSet);
        }

        @Override
        public DescribeStaleSecurityGroupsResponse build() {
            return new DescribeStaleSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeStaleSecurityGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder staleSecurityGroupSet(Collection<StaleSecurityGroup> var1);

        public Builder staleSecurityGroupSet(StaleSecurityGroup ... var1);

        public Builder staleSecurityGroupSet(Consumer<StaleSecurityGroup.Builder> ... var1);
    }
}

