/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.PrefixList;
import software.amazon.awssdk.services.ec2.model.PrefixListSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePrefixListsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribePrefixListsResponse> {
    private final String nextToken;
    private final List<PrefixList> prefixLists;

    private DescribePrefixListsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.prefixLists = builder.prefixLists;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<PrefixList> prefixLists() {
        return this.prefixLists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixLists());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrefixListsResponse)) {
            return false;
        }
        DescribePrefixListsResponse other = (DescribePrefixListsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.prefixLists(), other.prefixLists());
    }

    public String toString() {
        return ToString.builder((String)"DescribePrefixListsResponse").add("NextToken", (Object)this.nextToken()).add("PrefixLists", this.prefixLists()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PrefixLists": {
                return Optional.ofNullable(clazz.cast(this.prefixLists()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PrefixList> prefixLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrefixListsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.prefixLists(model.prefixLists);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PrefixList.Builder> getPrefixLists() {
            return this.prefixLists != null ? (Collection)this.prefixLists.stream().map(PrefixList::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder prefixLists(Collection<PrefixList> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copy(prefixLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixLists(PrefixList ... prefixLists) {
            this.prefixLists(Arrays.asList(prefixLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixLists(Consumer<PrefixList.Builder> ... prefixLists) {
            this.prefixLists(Stream.of(prefixLists).map(c -> (PrefixList)((PrefixList.Builder)PrefixList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrefixLists(Collection<PrefixList.BuilderImpl> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copyFromBuilder(prefixLists);
        }

        @Override
        public DescribePrefixListsResponse build() {
            return new DescribePrefixListsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribePrefixListsResponse> {
        public Builder nextToken(String var1);

        public Builder prefixLists(Collection<PrefixList> var1);

        public Builder prefixLists(PrefixList ... var1);

        public Builder prefixLists(Consumer<PrefixList.Builder> ... var1);
    }
}

