/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkAclsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeNetworkAclsRequest> {
    private final List<Filter> filters;
    private final List<String> networkAclIds;

    private DescribeNetworkAclsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.networkAclIds = builder.networkAclIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> networkAclIds() {
        return this.networkAclIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkAclsRequest)) {
            return false;
        }
        DescribeNetworkAclsRequest other = (DescribeNetworkAclsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.networkAclIds(), other.networkAclIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNetworkAclsRequest").add("Filters", this.filters()).add("NetworkAclIds", this.networkAclIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NetworkAclIds": {
                return Optional.ofNullable(clazz.cast(this.networkAclIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkAclIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkAclsRequest model) {
            super(model);
            this.filters(model.filters);
            this.networkAclIds(model.networkAclIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getNetworkAclIds() {
            return this.networkAclIds;
        }

        @Override
        public final Builder networkAclIds(Collection<String> networkAclIds) {
            this.networkAclIds = ValueStringListCopier.copy(networkAclIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAclIds(String ... networkAclIds) {
            this.networkAclIds(Arrays.asList(networkAclIds));
            return this;
        }

        public final void setNetworkAclIds(Collection<String> networkAclIds) {
            this.networkAclIds = ValueStringListCopier.copy(networkAclIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkAclsRequest build() {
            return new DescribeNetworkAclsRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DescribeNetworkAclsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder networkAclIds(Collection<String> var1);

        public Builder networkAclIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

