/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.NatGateway;
import software.amazon.awssdk.services.ec2.model.NatGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNatGatewaysResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeNatGatewaysResponse> {
    private final List<NatGateway> natGateways;
    private final String nextToken;

    private DescribeNatGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.natGateways = builder.natGateways;
        this.nextToken = builder.nextToken;
    }

    public List<NatGateway> natGateways() {
        return this.natGateways;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.natGateways());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNatGatewaysResponse)) {
            return false;
        }
        DescribeNatGatewaysResponse other = (DescribeNatGatewaysResponse)((Object)obj);
        return Objects.equals(this.natGateways(), other.natGateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNatGatewaysResponse").add("NatGateways", this.natGateways()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NatGateways": {
                return Optional.ofNullable(clazz.cast(this.natGateways()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<NatGateway> natGateways = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNatGatewaysResponse model) {
            super(model);
            this.natGateways(model.natGateways);
            this.nextToken(model.nextToken);
        }

        public final Collection<NatGateway.Builder> getNatGateways() {
            return this.natGateways != null ? (Collection)this.natGateways.stream().map(NatGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder natGateways(Collection<NatGateway> natGateways) {
            this.natGateways = NatGatewayListCopier.copy(natGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGateways(NatGateway ... natGateways) {
            this.natGateways(Arrays.asList(natGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGateways(Consumer<NatGateway.Builder> ... natGateways) {
            this.natGateways(Stream.of(natGateways).map(c -> (NatGateway)((NatGateway.Builder)NatGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNatGateways(Collection<NatGateway.BuilderImpl> natGateways) {
            this.natGateways = NatGatewayListCopier.copyFromBuilder(natGateways);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNatGatewaysResponse build() {
            return new DescribeNatGatewaysResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeNatGatewaysResponse> {
        public Builder natGateways(Collection<NatGateway> var1);

        public Builder natGateways(NatGateway ... var1);

        public Builder natGateways(Consumer<NatGateway.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

