/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssignIpv6AddressesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AssignIpv6AddressesResponse> {
    private final List<String> assignedIpv6Addresses;
    private final String networkInterfaceId;

    private AssignIpv6AddressesResponse(BuilderImpl builder) {
        super(builder);
        this.assignedIpv6Addresses = builder.assignedIpv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public List<String> assignedIpv6Addresses() {
        return this.assignedIpv6Addresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assignedIpv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesResponse)) {
            return false;
        }
        AssignIpv6AddressesResponse other = (AssignIpv6AddressesResponse)((Object)obj);
        return Objects.equals(this.assignedIpv6Addresses(), other.assignedIpv6Addresses()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId());
    }

    public String toString() {
        return ToString.builder((String)"AssignIpv6AddressesResponse").add("AssignedIpv6Addresses", this.assignedIpv6Addresses()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignedIpv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.assignedIpv6Addresses()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<String> assignedIpv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignIpv6AddressesResponse model) {
            super(model);
            this.assignedIpv6Addresses(model.assignedIpv6Addresses);
            this.networkInterfaceId(model.networkInterfaceId);
        }

        public final Collection<String> getAssignedIpv6Addresses() {
            return this.assignedIpv6Addresses;
        }

        @Override
        public final Builder assignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv6Addresses(String ... assignedIpv6Addresses) {
            this.assignedIpv6Addresses(Arrays.asList(assignedIpv6Addresses));
            return this;
        }

        public final void setAssignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public AssignIpv6AddressesResponse build() {
            return new AssignIpv6AddressesResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, AssignIpv6AddressesResponse> {
        public Builder assignedIpv6Addresses(Collection<String> var1);

        public Builder assignedIpv6Addresses(String ... var1);

        public Builder networkInterfaceId(String var1);
    }
}

