/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.Vpc;
import software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VpcCidrBlockAssociationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VpcIpv6CidrBlockAssociationUnmarshaller;

public class VpcUnmarshaller
implements Unmarshaller<Vpc, StaxUnmarshallerContext> {
    private static final VpcUnmarshaller INSTANCE = new VpcUnmarshaller();

    public Vpc unmarshall(StaxUnmarshallerContext context) throws Exception {
        Vpc.Builder vpc;
        block15: {
            vpc = Vpc.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = null;
            ArrayList<VpcCidrBlockAssociation> cidrBlockAssociationSet = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    vpc.ipv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet);
                    vpc.cidrBlockAssociationSet(cidrBlockAssociationSet);
                    vpc.tags(tags);
                    break block15;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("cidrBlock", targetDepth)) {
                        vpc.cidrBlock(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("dhcpOptionsId", targetDepth)) {
                        vpc.dhcpOptionsId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("state", targetDepth)) {
                        vpc.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("vpcId", targetDepth)) {
                        vpc.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceTenancy", targetDepth)) {
                        vpc.instanceTenancy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ipv6CidrBlockAssociationSet", targetDepth)) {
                        ipv6CidrBlockAssociationSet = new ArrayList<VpcIpv6CidrBlockAssociation>();
                        continue;
                    }
                    if (context.testExpression("ipv6CidrBlockAssociationSet/item", targetDepth)) {
                        ipv6CidrBlockAssociationSet.add(VpcIpv6CidrBlockAssociationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("cidrBlockAssociationSet", targetDepth)) {
                        cidrBlockAssociationSet = new ArrayList<VpcCidrBlockAssociation>();
                        continue;
                    }
                    if (context.testExpression("cidrBlockAssociationSet/item", targetDepth)) {
                        cidrBlockAssociationSet.add(VpcCidrBlockAssociationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("isDefault", targetDepth)) {
                        vpc.isDefault(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("tagSet/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            vpc.ipv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet);
            vpc.cidrBlockAssociationSet(cidrBlockAssociationSet);
            vpc.tags(tags);
        }
        return (Vpc)vpc.build();
    }

    public static VpcUnmarshaller getInstance() {
        return INSTANCE;
    }
}

