/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.IpPermissionUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class SecurityGroupUnmarshaller
implements Unmarshaller<SecurityGroup, StaxUnmarshallerContext> {
    private static final SecurityGroupUnmarshaller INSTANCE = new SecurityGroupUnmarshaller();

    public SecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        SecurityGroup.Builder securityGroup;
        block14: {
            securityGroup = SecurityGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<IpPermission> ipPermissions = null;
            ArrayList<IpPermission> ipPermissionsEgress = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    securityGroup.ipPermissions(ipPermissions);
                    securityGroup.ipPermissionsEgress(ipPermissionsEgress);
                    securityGroup.tags(tags);
                    break block14;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("groupDescription", targetDepth)) {
                        securityGroup.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("groupName", targetDepth)) {
                        securityGroup.groupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ipPermissions", targetDepth)) {
                        ipPermissions = new ArrayList<IpPermission>();
                        continue;
                    }
                    if (context.testExpression("ipPermissions/item", targetDepth)) {
                        ipPermissions.add(IpPermissionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ownerId", targetDepth)) {
                        securityGroup.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("groupId", targetDepth)) {
                        securityGroup.groupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ipPermissionsEgress", targetDepth)) {
                        ipPermissionsEgress = new ArrayList<IpPermission>();
                        continue;
                    }
                    if (context.testExpression("ipPermissionsEgress/item", targetDepth)) {
                        ipPermissionsEgress.add(IpPermissionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("tagSet/item", targetDepth)) {
                        tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("vpcId", targetDepth)) continue;
                    securityGroup.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            securityGroup.ipPermissions(ipPermissions);
            securityGroup.ipPermissionsEgress(ipPermissionsEgress);
            securityGroup.tags(tags);
        }
        return (SecurityGroup)securityGroup.build();
    }

    public static SecurityGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

