/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        List<String> list;
        List<String> describeSnapshotsRequestRestorableByUserIdsList;
        List<String> describeSnapshotsRequestOwnerIdsList;
        if (describeSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeSnapshotsRequest, "EC2Client");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeSnapshotsRequestFiltersList = describeSnapshotsRequest.filters();
        if (describeSnapshotsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter filter : describeSnapshotsRequestFiltersList) {
                List<String> list2;
                if (filter.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filter.name()));
                }
                if ((list2 = filter.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : list2) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeSnapshotsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSnapshotsRequest.maxResults()));
        }
        if (describeSnapshotsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSnapshotsRequest.nextToken()));
        }
        if ((describeSnapshotsRequestOwnerIdsList = describeSnapshotsRequest.ownerIds()) != null) {
            int ownerIdsListIndex = 1;
            for (String string : describeSnapshotsRequestOwnerIdsList) {
                if (string != null) {
                    request.addParameter("Owner." + ownerIdsListIndex, StringUtils.fromString((String)string));
                }
                ++ownerIdsListIndex;
            }
        }
        if ((describeSnapshotsRequestRestorableByUserIdsList = describeSnapshotsRequest.restorableByUserIds()) != null) {
            boolean bl = true;
            for (String describeSnapshotsRequestRestorableByUserIdsListValue : describeSnapshotsRequestRestorableByUserIdsList) {
                void var6_12;
                if (describeSnapshotsRequestRestorableByUserIdsListValue != null) {
                    request.addParameter("RestorableBy." + (int)var6_12, StringUtils.fromString((String)describeSnapshotsRequestRestorableByUserIdsListValue));
                }
                ++var6_12;
            }
        }
        if ((list = describeSnapshotsRequest.snapshotIds()) != null) {
            boolean bl = true;
            for (String describeSnapshotsRequestSnapshotIdsListValue : list) {
                void var7_20;
                if (describeSnapshotsRequestSnapshotIdsListValue != null) {
                    request.addParameter("SnapshotId." + (int)var7_20, StringUtils.fromString((String)describeSnapshotsRequestSnapshotIdsListValue));
                }
                ++var7_20;
            }
        }
        return request;
    }
}

