/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest;

public class DescribeAccountAttributesRequestMarshaller
implements Marshaller<Request<DescribeAccountAttributesRequest>, DescribeAccountAttributesRequest> {
    public Request<DescribeAccountAttributesRequest> marshall(DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        if (describeAccountAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeAccountAttributesRequest, "EC2Client");
        request.addParameter("Action", "DescribeAccountAttributes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeAccountAttributesRequestAttributeNamesList = describeAccountAttributesRequest.attributeNamesAsStrings();
        if (describeAccountAttributesRequestAttributeNamesList != null) {
            int attributeNamesListIndex = 1;
            for (String describeAccountAttributesRequestAttributeNamesListValue : describeAccountAttributesRequestAttributeNamesList) {
                if (describeAccountAttributesRequestAttributeNamesListValue != null) {
                    request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString((String)describeAccountAttributesRequestAttributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        return request;
    }
}

