/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest;

public class DeleteFlowLogsRequestMarshaller
implements Marshaller<Request<DeleteFlowLogsRequest>, DeleteFlowLogsRequest> {
    public Request<DeleteFlowLogsRequest> marshall(DeleteFlowLogsRequest deleteFlowLogsRequest) {
        if (deleteFlowLogsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteFlowLogsRequest, "EC2Client");
        request.addParameter("Action", "DeleteFlowLogs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> deleteFlowLogsRequestFlowLogIdsList = deleteFlowLogsRequest.flowLogIds();
        if (deleteFlowLogsRequestFlowLogIdsList != null) {
            int flowLogIdsListIndex = 1;
            for (String deleteFlowLogsRequestFlowLogIdsListValue : deleteFlowLogsRequestFlowLogIdsList) {
                if (deleteFlowLogsRequestFlowLogIdsListValue != null) {
                    request.addParameter("FlowLogId." + flowLogIdsListIndex, StringUtils.fromString((String)deleteFlowLogsRequestFlowLogIdsListValue));
                }
                ++flowLogIdsListIndex;
            }
        }
        return request;
    }
}

