/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.AllocateAddressRequest;

public class AllocateAddressRequestMarshaller
implements Marshaller<Request<AllocateAddressRequest>, AllocateAddressRequest> {
    public Request<AllocateAddressRequest> marshall(AllocateAddressRequest allocateAddressRequest) {
        if (allocateAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)allocateAddressRequest, "EC2Client");
        request.addParameter("Action", "AllocateAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (allocateAddressRequest.domainAsString() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)allocateAddressRequest.domainAsString()));
        }
        if (allocateAddressRequest.address() != null) {
            request.addParameter("Address", StringUtils.fromString((String)allocateAddressRequest.address()));
        }
        return request;
    }
}

