/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.SpotPrice;

public class DescribeSpotPriceHistoryIterable
implements SdkIterable<DescribeSpotPriceHistoryResponse> {
    private final EC2Client client;
    private final DescribeSpotPriceHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSpotPriceHistoryIterable(EC2Client client, DescribeSpotPriceHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSpotPriceHistoryResponseFetcher();
    }

    public Iterator<DescribeSpotPriceHistoryResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<SpotPrice> spotPriceHistory() {
        Function<DescribeSpotPriceHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.spotPriceHistory() != null) {
                return response.spotPriceHistory().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeSpotPriceHistoryIterable resume(DescribeSpotPriceHistoryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeSpotPriceHistoryIterable(this.client, (DescribeSpotPriceHistoryRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeSpotPriceHistoryIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeSpotPriceHistoryResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeSpotPriceHistoryResponseFetcher
    implements SyncPageFetcher<DescribeSpotPriceHistoryResponse> {
        private DescribeSpotPriceHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpotPriceHistoryResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeSpotPriceHistoryResponse nextPage(DescribeSpotPriceHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpotPriceHistoryIterable.this.client.describeSpotPriceHistory(DescribeSpotPriceHistoryIterable.this.firstRequest);
            }
            return DescribeSpotPriceHistoryIterable.this.client.describeSpotPriceHistory((DescribeSpotPriceHistoryRequest)((Object)DescribeSpotPriceHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

