/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3Storage
implements ToCopyableBuilder<Builder, S3Storage> {
    private final String awsAccessKeyId;
    private final String bucket;
    private final String prefix;
    private final String uploadPolicy;
    private final String uploadPolicySignature;

    private S3Storage(BuilderImpl builder) {
        this.awsAccessKeyId = builder.awsAccessKeyId;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
        this.uploadPolicy = builder.uploadPolicy;
        this.uploadPolicySignature = builder.uploadPolicySignature;
    }

    public String awsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }

    public String uploadPolicy() {
        return this.uploadPolicy;
    }

    public String uploadPolicySignature() {
        return this.uploadPolicySignature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadPolicySignature());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Storage)) {
            return false;
        }
        S3Storage other = (S3Storage)obj;
        return Objects.equals(this.awsAccessKeyId(), other.awsAccessKeyId()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.uploadPolicy(), other.uploadPolicy()) && Objects.equals(this.uploadPolicySignature(), other.uploadPolicySignature());
    }

    public String toString() {
        return ToString.builder((String)"S3Storage").add("AWSAccessKeyId", (Object)this.awsAccessKeyId()).add("Bucket", (Object)this.bucket()).add("Prefix", (Object)this.prefix()).add("UploadPolicy", (Object)this.uploadPolicy()).add("UploadPolicySignature", (Object)this.uploadPolicySignature()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSAccessKeyId": {
                return Optional.of(clazz.cast(this.awsAccessKeyId()));
            }
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "UploadPolicy": {
                return Optional.of(clazz.cast(this.uploadPolicy()));
            }
            case "UploadPolicySignature": {
                return Optional.of(clazz.cast(this.uploadPolicySignature()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccessKeyId;
        private String bucket;
        private String prefix;
        private String uploadPolicy;
        private String uploadPolicySignature;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Storage model) {
            this.awsAccessKeyId(model.awsAccessKeyId);
            this.bucket(model.bucket);
            this.prefix(model.prefix);
            this.uploadPolicy(model.uploadPolicy);
            this.uploadPolicySignature(model.uploadPolicySignature);
        }

        public final String getAWSAccessKeyId() {
            return this.awsAccessKeyId;
        }

        @Override
        public final Builder awsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
            return this;
        }

        public final void setAWSAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getUploadPolicy() {
            return this.uploadPolicy;
        }

        @Override
        public final Builder uploadPolicy(String uploadPolicy) {
            this.uploadPolicy = uploadPolicy;
            return this;
        }

        public final void setUploadPolicy(String uploadPolicy) {
            this.uploadPolicy = uploadPolicy;
        }

        public final String getUploadPolicySignature() {
            return this.uploadPolicySignature;
        }

        @Override
        public final Builder uploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
            return this;
        }

        public final void setUploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
        }

        public S3Storage build() {
            return new S3Storage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Storage> {
        public Builder awsAccessKeyId(String var1);

        public Builder bucket(String var1);

        public Builder prefix(String var1);

        public Builder uploadPolicy(String var1);

        public Builder uploadPolicySignature(String var1);
    }
}

