/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResetImageAttributeRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ResetImageAttributeRequest> {
    private final String attribute;
    private final String imageId;

    private ResetImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.imageId = builder.imageId;
    }

    public ResetImageAttributeName attribute() {
        return ResetImageAttributeName.fromValue(this.attribute);
    }

    public String attributeAsString() {
        return this.attribute;
    }

    public String imageId() {
        return this.imageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetImageAttributeRequest)) {
            return false;
        }
        ResetImageAttributeRequest other = (ResetImageAttributeRequest)((Object)obj);
        return Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.imageId(), other.imageId());
    }

    public String toString() {
        return ToString.builder((String)"ResetImageAttributeRequest").add("Attribute", (Object)this.attributeAsString()).add("ImageId", (Object)this.imageId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.of(clazz.cast(this.attributeAsString()));
            }
            case "ImageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String attribute;
        private String imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetImageAttributeRequest model) {
            super(model);
            this.attribute(model.attribute);
            this.imageId(model.imageId);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResetImageAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ResetImageAttributeRequest build() {
            return new ResetImageAttributeRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ResetImageAttributeRequest> {
        public Builder attribute(String var1);

        public Builder attribute(ResetImageAttributeName var1);

        public Builder imageId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

