/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesId;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResult;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResultListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedIntancesIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstancesModification
implements ToCopyableBuilder<Builder, ReservedInstancesModification> {
    private final String clientToken;
    private final Instant createDate;
    private final Instant effectiveDate;
    private final List<ReservedInstancesModificationResult> modificationResults;
    private final List<ReservedInstancesId> reservedInstancesIds;
    private final String reservedInstancesModificationId;
    private final String status;
    private final String statusMessage;
    private final Instant updateDate;

    private ReservedInstancesModification(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.effectiveDate = builder.effectiveDate;
        this.modificationResults = builder.modificationResults;
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.reservedInstancesModificationId = builder.reservedInstancesModificationId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.updateDate = builder.updateDate;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Instant effectiveDate() {
        return this.effectiveDate;
    }

    public List<ReservedInstancesModificationResult> modificationResults() {
        return this.modificationResults;
    }

    public List<ReservedInstancesId> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    public String reservedInstancesModificationId() {
        return this.reservedInstancesModificationId;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesModificationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesModification)) {
            return false;
        }
        ReservedInstancesModification other = (ReservedInstancesModification)obj;
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.effectiveDate(), other.effectiveDate()) && Objects.equals(this.modificationResults(), other.modificationResults()) && Objects.equals(this.reservedInstancesIds(), other.reservedInstancesIds()) && Objects.equals(this.reservedInstancesModificationId(), other.reservedInstancesModificationId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.updateDate(), other.updateDate());
    }

    public String toString() {
        return ToString.builder((String)"ReservedInstancesModification").add("ClientToken", (Object)this.clientToken()).add("CreateDate", (Object)this.createDate()).add("EffectiveDate", (Object)this.effectiveDate()).add("ModificationResults", this.modificationResults()).add("ReservedInstancesIds", this.reservedInstancesIds()).add("ReservedInstancesModificationId", (Object)this.reservedInstancesModificationId()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).add("UpdateDate", (Object)this.updateDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "EffectiveDate": {
                return Optional.of(clazz.cast(this.effectiveDate()));
            }
            case "ModificationResults": {
                return Optional.of(clazz.cast(this.modificationResults()));
            }
            case "ReservedInstancesIds": {
                return Optional.of(clazz.cast(this.reservedInstancesIds()));
            }
            case "ReservedInstancesModificationId": {
                return Optional.of(clazz.cast(this.reservedInstancesModificationId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.of(clazz.cast(this.statusMessage()));
            }
            case "UpdateDate": {
                return Optional.of(clazz.cast(this.updateDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Instant createDate;
        private Instant effectiveDate;
        private List<ReservedInstancesModificationResult> modificationResults;
        private List<ReservedInstancesId> reservedInstancesIds;
        private String reservedInstancesModificationId;
        private String status;
        private String statusMessage;
        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesModification model) {
            this.clientToken(model.clientToken);
            this.createDate(model.createDate);
            this.effectiveDate(model.effectiveDate);
            this.modificationResults(model.modificationResults);
            this.reservedInstancesIds(model.reservedInstancesIds);
            this.reservedInstancesModificationId(model.reservedInstancesModificationId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.updateDate(model.updateDate);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        public final Collection<ReservedInstancesModificationResult.Builder> getModificationResults() {
            return this.modificationResults != null ? (Collection)this.modificationResults.stream().map(ReservedInstancesModificationResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modificationResults(Collection<ReservedInstancesModificationResult> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copy(modificationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationResults(ReservedInstancesModificationResult ... modificationResults) {
            this.modificationResults(Arrays.asList(modificationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationResults(Consumer<ReservedInstancesModificationResult.Builder> ... modificationResults) {
            this.modificationResults(Stream.of(modificationResults).map(c -> (ReservedInstancesModificationResult)((ReservedInstancesModificationResult.Builder)ReservedInstancesModificationResult.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModificationResults(Collection<ReservedInstancesModificationResult.BuilderImpl> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copyFromBuilder(modificationResults);
        }

        public final Collection<ReservedInstancesId.Builder> getReservedInstancesIds() {
            return this.reservedInstancesIds != null ? (Collection)this.reservedInstancesIds.stream().map(ReservedInstancesId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<ReservedInstancesId> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(ReservedInstancesId ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(Consumer<ReservedInstancesId.Builder> ... reservedInstancesIds) {
            this.reservedInstancesIds(Stream.of(reservedInstancesIds).map(c -> (ReservedInstancesId)((ReservedInstancesId.Builder)ReservedInstancesId.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstancesIds(Collection<ReservedInstancesId.BuilderImpl> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copyFromBuilder(reservedInstancesIds);
        }

        public final String getReservedInstancesModificationId() {
            return this.reservedInstancesModificationId;
        }

        @Override
        public final Builder reservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
            return this;
        }

        public final void setReservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public ReservedInstancesModification build() {
            return new ReservedInstancesModification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstancesModification> {
        public Builder clientToken(String var1);

        public Builder createDate(Instant var1);

        public Builder effectiveDate(Instant var1);

        public Builder modificationResults(Collection<ReservedInstancesModificationResult> var1);

        public Builder modificationResults(ReservedInstancesModificationResult ... var1);

        public Builder modificationResults(Consumer<ReservedInstancesModificationResult.Builder> ... var1);

        public Builder reservedInstancesIds(Collection<ReservedInstancesId> var1);

        public Builder reservedInstancesIds(ReservedInstancesId ... var1);

        public Builder reservedInstancesIds(Consumer<ReservedInstancesId.Builder> ... var1);

        public Builder reservedInstancesModificationId(String var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);

        public Builder updateDate(Instant var1);
    }
}

