/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.PlacementGroupState;
import software.amazon.awssdk.services.ec2.model.PlacementStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlacementGroup
implements ToCopyableBuilder<Builder, PlacementGroup> {
    private final String groupName;
    private final String state;
    private final String strategy;

    private PlacementGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.state = builder.state;
        this.strategy = builder.strategy;
    }

    public String groupName() {
        return this.groupName;
    }

    public PlacementGroupState state() {
        return PlacementGroupState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(this.strategy);
    }

    public String strategyAsString() {
        return this.strategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroup)) {
            return false;
        }
        PlacementGroup other = (PlacementGroup)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.strategyAsString(), other.strategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"PlacementGroup").add("GroupName", (Object)this.groupName()).add("State", (Object)this.stateAsString()).add("Strategy", (Object)this.strategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "Strategy": {
                return Optional.of(clazz.cast(this.strategyAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String state;
        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementGroup model) {
            this.groupName(model.groupName);
            this.state(model.state);
            this.strategy(model.strategy);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PlacementGroupState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public PlacementGroup build() {
            return new PlacementGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlacementGroup> {
        public Builder groupName(String var1);

        public Builder state(String var1);

        public Builder state(PlacementGroupState var1);

        public Builder strategy(String var1);

        public Builder strategy(PlacementStrategy var1);
    }
}

