/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ExportEnvironment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceExportDetails
implements ToCopyableBuilder<Builder, InstanceExportDetails> {
    private final String instanceId;
    private final String targetEnvironment;

    private InstanceExportDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.targetEnvironment = builder.targetEnvironment;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public ExportEnvironment targetEnvironment() {
        return ExportEnvironment.fromValue(this.targetEnvironment);
    }

    public String targetEnvironmentAsString() {
        return this.targetEnvironment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEnvironmentAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceExportDetails)) {
            return false;
        }
        InstanceExportDetails other = (InstanceExportDetails)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.targetEnvironmentAsString(), other.targetEnvironmentAsString());
    }

    public String toString() {
        return ToString.builder((String)"InstanceExportDetails").add("InstanceId", (Object)this.instanceId()).add("TargetEnvironment", (Object)this.targetEnvironmentAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "TargetEnvironment": {
                return Optional.of(clazz.cast(this.targetEnvironmentAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String targetEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceExportDetails model) {
            this.instanceId(model.instanceId);
            this.targetEnvironment(model.targetEnvironment);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTargetEnvironment() {
            return this.targetEnvironment;
        }

        @Override
        public final Builder targetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
            return this;
        }

        @Override
        public final Builder targetEnvironment(ExportEnvironment targetEnvironment) {
            this.targetEnvironment(targetEnvironment.toString());
            return this;
        }

        public final void setTargetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
        }

        public InstanceExportDetails build() {
            return new InstanceExportDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceExportDetails> {
        public Builder instanceId(String var1);

        public Builder targetEnvironment(String var1);

        public Builder targetEnvironment(ExportEnvironment var1);
    }
}

