/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportSnapshotResponse
extends EC2Response
implements ToCopyableBuilder<Builder, ImportSnapshotResponse> {
    private final String description;
    private final String importTaskId;
    private final SnapshotTaskDetail snapshotTaskDetail;

    private ImportSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.importTaskId = builder.importTaskId;
        this.snapshotTaskDetail = builder.snapshotTaskDetail;
    }

    public String description() {
        return this.description;
    }

    public String importTaskId() {
        return this.importTaskId;
    }

    public SnapshotTaskDetail snapshotTaskDetail() {
        return this.snapshotTaskDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotTaskDetail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotResponse)) {
            return false;
        }
        ImportSnapshotResponse other = (ImportSnapshotResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.importTaskId(), other.importTaskId()) && Objects.equals(this.snapshotTaskDetail(), other.snapshotTaskDetail());
    }

    public String toString() {
        return ToString.builder((String)"ImportSnapshotResponse").add("Description", (Object)this.description()).add("ImportTaskId", (Object)this.importTaskId()).add("SnapshotTaskDetail", (Object)this.snapshotTaskDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ImportTaskId": {
                return Optional.of(clazz.cast(this.importTaskId()));
            }
            case "SnapshotTaskDetail": {
                return Optional.of(clazz.cast(this.snapshotTaskDetail()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String description;
        private String importTaskId;
        private SnapshotTaskDetail snapshotTaskDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotResponse model) {
            super(model);
            this.description(model.description);
            this.importTaskId(model.importTaskId);
            this.snapshotTaskDetail(model.snapshotTaskDetail);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImportTaskId() {
            return this.importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final SnapshotTaskDetail.Builder getSnapshotTaskDetail() {
            return this.snapshotTaskDetail != null ? this.snapshotTaskDetail.toBuilder() : null;
        }

        @Override
        public final Builder snapshotTaskDetail(SnapshotTaskDetail snapshotTaskDetail) {
            this.snapshotTaskDetail = snapshotTaskDetail;
            return this;
        }

        public final void setSnapshotTaskDetail(SnapshotTaskDetail.BuilderImpl snapshotTaskDetail) {
            this.snapshotTaskDetail = snapshotTaskDetail != null ? snapshotTaskDetail.build() : null;
        }

        @Override
        public ImportSnapshotResponse build() {
            return new ImportSnapshotResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, ImportSnapshotResponse> {
        public Builder description(String var1);

        public Builder importTaskId(String var1);

        public Builder snapshotTaskDetail(SnapshotTaskDetail var1);

        default public Builder snapshotTaskDetail(Consumer<SnapshotTaskDetail.Builder> snapshotTaskDetail) {
            return this.snapshotTaskDetail((SnapshotTaskDetail)((SnapshotTaskDetail.Builder)SnapshotTaskDetail.builder().apply(snapshotTaskDetail)).build());
        }
    }
}

