/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.RequestHostIdSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHostReservationPurchasePreviewRequest
extends EC2Request
implements ToCopyableBuilder<Builder, GetHostReservationPurchasePreviewRequest> {
    private final List<String> hostIdSet;
    private final String offeringId;

    private GetHostReservationPurchasePreviewRequest(BuilderImpl builder) {
        super(builder);
        this.hostIdSet = builder.hostIdSet;
        this.offeringId = builder.offeringId;
    }

    public List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public String offeringId() {
        return this.offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostIdSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostReservationPurchasePreviewRequest)) {
            return false;
        }
        GetHostReservationPurchasePreviewRequest other = (GetHostReservationPurchasePreviewRequest)((Object)obj);
        return Objects.equals(this.hostIdSet(), other.hostIdSet()) && Objects.equals(this.offeringId(), other.offeringId());
    }

    public String toString() {
        return ToString.builder((String)"GetHostReservationPurchasePreviewRequest").add("HostIdSet", this.hostIdSet()).add("OfferingId", (Object)this.offeringId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostIdSet": {
                return Optional.of(clazz.cast(this.hostIdSet()));
            }
            case "OfferingId": {
                return Optional.of(clazz.cast(this.offeringId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<String> hostIdSet;
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostReservationPurchasePreviewRequest model) {
            super(model);
            this.hostIdSet(model.hostIdSet);
            this.offeringId(model.offeringId);
        }

        public final Collection<String> getHostIdSet() {
            return this.hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            this.hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetHostReservationPurchasePreviewRequest build() {
            return new GetHostReservationPurchasePreviewRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, GetHostReservationPurchasePreviewRequest> {
        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder offeringId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

