/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequest;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSpotInstanceRequestsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeSpotInstanceRequestsResponse> {
    private final List<SpotInstanceRequest> spotInstanceRequests;

    private DescribeSpotInstanceRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.spotInstanceRequests = builder.spotInstanceRequests;
    }

    public List<SpotInstanceRequest> spotInstanceRequests() {
        return this.spotInstanceRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotInstanceRequestsResponse)) {
            return false;
        }
        DescribeSpotInstanceRequestsResponse other = (DescribeSpotInstanceRequestsResponse)((Object)obj);
        return Objects.equals(this.spotInstanceRequests(), other.spotInstanceRequests());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSpotInstanceRequestsResponse").add("SpotInstanceRequests", this.spotInstanceRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotInstanceRequests": {
                return Optional.of(clazz.cast(this.spotInstanceRequests()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<SpotInstanceRequest> spotInstanceRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotInstanceRequestsResponse model) {
            super(model);
            this.spotInstanceRequests(model.spotInstanceRequests);
        }

        public final Collection<SpotInstanceRequest.Builder> getSpotInstanceRequests() {
            return this.spotInstanceRequests != null ? (Collection)this.spotInstanceRequests.stream().map(SpotInstanceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder spotInstanceRequests(Collection<SpotInstanceRequest> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copy(spotInstanceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(SpotInstanceRequest ... spotInstanceRequests) {
            this.spotInstanceRequests(Arrays.asList(spotInstanceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(Consumer<SpotInstanceRequest.Builder> ... spotInstanceRequests) {
            this.spotInstanceRequests(Stream.of(spotInstanceRequests).map(c -> (SpotInstanceRequest)((SpotInstanceRequest.Builder)SpotInstanceRequest.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSpotInstanceRequests(Collection<SpotInstanceRequest.BuilderImpl> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copyFromBuilder(spotInstanceRequests);
        }

        @Override
        public DescribeSpotInstanceRequestsResponse build() {
            return new DescribeSpotInstanceRequestsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeSpotInstanceRequestsResponse> {
        public Builder spotInstanceRequests(Collection<SpotInstanceRequest> var1);

        public Builder spotInstanceRequests(SpotInstanceRequest ... var1);

        public Builder spotInstanceRequests(Consumer<SpotInstanceRequest.Builder> ... var1);
    }
}

